﻿/*
	VERSION:		1.0
	
	DESCRIPTION:
		This enables drag & drop events for a movieClip.
		Create one for each draggable movieClip.
	
	NOTE:		This object uses a listener, therefore:
		Call the pseudo-destructor function:  _DragAndDrop()  INSTEAD of using "delete",  and also before deleting this object's parent.
		(Unfortunately, Listeners don't go away by themselves.  And there's no way to create "real" destructor functions.)
*/



class DragAndDrop
{
	// _____________________________________________________________
	// Variables
	
	var target;										// This is the movieClip that is being clicked or dragged.
	var isPressed;								// This indicates whether the mouse button is still down, after clicking the target movieClip.
	var start:flash.geom.Point;				// This is the location where the mouse was, when it clicked the movieClip, relative to the movieClip's parent.
	var current:flash.geom.Point;			// This is the current location of the mouse pointer, relative to the target movieClip's parent.
	var distance:flash.geom.Point;			// This is the Horizontal and Vertical distances between the starting point, and the current point.
	// ...........................................................................................................
	var ASBroadcaster;							// Enables using the ASBroadcaster
	var _listeners:Array;						// Created by the ASBroadcaster
	var broadcastMessage:Function;		// Created by the ASBroadcaster
	// ...........................................................................................................
	// Public functions, that can be externally defined.
	// Alternatively, this object also dispatches events with the same names.
	var click:Function;
	var drag:Function;
	var drop:Function;
	
	
	
	// _____________________________________________________________
	// Setup
	
	function DragAndDrop( target )
	{
		ASBroadcaster.initialize( this );		// Enable event broadcasting
		Mouse.addListener( this );
	}// CONSTRUCTOR
	
	
	function _DragAndDrop()
	{
		Mouse.removeListener( this );
		this._listeners = new Array();		// removes all the listeners  (hopefully)
		delete this;
	}// pseudo-DESTRUCTOR
	
	
	
	// _____________________________________________________________
	// Mouse methods
	
	
	function onMouseDown()
	{
		// confirm target, via hitTest
		var mouseX = _root._xmouse;
		var mouseY = _root._ymouse;
		if (target.hitTest( mouseX, mouseY, true ))
		{
			this.isPressed = true;
			start = new flash.geom.Point( target._parent._xmouse, target._parent._ymouse );
			click( start );
			this.broadcastMessage( "click", start );
		}// hitTest()
	}// onMouseDown()
	
	// ...........................................................................................................
	
	function onMouseMove()
	{
		if(this.isPressed)
		{
			current = new flash.geom.Point( target._parent._xmouse, target._parent._ymouse );
			distance = current.subtract( start );
			drag( start, current, distance );
			this.broadcastMessage( "drag", start, current, distance );
		}// if:  The movieClip is being dragged
	}// onMouseMove()
	
	// ...........................................................................................................
	
	function onMouseUp()
	{
		if(this.isPressed)
		{
			current = new flash.geom.Point( target._parent._xmouse, target._parent._ymouse );
			distance = current.subtract( start );
			drop( start, current, distance );
			this.broadcastMessage( "drop", start, current, distance );
		}// if:  The movieClip was being dragged
		this.isPressed = false;
	}// onMouseUp()
}// DragAndDrop()